--# Functions3D

function placeAtRandomPosition(object)
    object.x = math.random(WIDTH)
    object.y = math.random(HEIGHT)
    local positionVec = vec2(object.x, object.y)
    object.entity.position = craftPositionFrom(positionVec)
end

function makeOrb(pixelDiameter, pos, color)
    local camera = scene.camera:get(craft.camera)
    scene:update(DeltaTime)
    camera.ortho = true 
    camera.orthoSize = 100
    local entity = craft.scene.main:entity()
    entity.model = craft.model(asset.builtin.Primitives.Sphere)
    entity.material = craft.material(asset.builtin.Materials.Specular)
    entity.material.diffuse = color or color(255)
    entity.position = scene.camera:get(craft.camera):screenToWorld(vec3(pos.x,pos.y,20))
    entity.position = craftPositionFrom(pos)
    entity.scale = vec3(1,1,1) * craftSizeFrom(pixelDiameter/2)
    return entity
end

function craftPositionFrom(screenPosition)
    local cam = craft.scene.main.camera:get(craft.camera)
    return cam:screenToWorld(vec3(screenPosition.x,screenPosition.y,20))
end

function craftSizeFrom(numPixels)
    local camera = scene.camera:get(craft.camera)    
    -- Convert two points a known distance apart in screen space to world space
    local point1 = camera:screenToWorld(vec3(0, 0, 20))
    local point2 = camera:screenToWorld(vec3(numPixels, 0, 20))    
    -- Calculate the distance between the two points in world space
    return (point2 - point1):len()
end

function setOrbsVisible(isVis)
    for i, v in pairs(stationaryObs) do
        v.entity.active = isVis
    end
    enemy.entity.active = isVis
    coin.entity.active = isVis
    player.active = isVis
end

function hideAllOrbsButEnemy()
    setOrbsVisible(false)
    enemy.entity.active = true
end